/*
 * Decompiled with CFR 0.152.
 */
package zombie_extreme;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;
import zombie_extreme.ZombieExtremeMod;

public class ZombieExtremeModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public ZombieExtremeModElements() {
        sounds.put(new ResourceLocation("zombie_extreme", "shoot_pistol"), new SoundEvent(new ResourceLocation("zombie_extreme", "shoot_pistol")));
        sounds.put(new ResourceLocation("zombie_extreme", "self_made_reload"), new SoundEvent(new ResourceLocation("zombie_extreme", "self_made_reload")));
        sounds.put(new ResourceLocation("zombie_extreme", "self_made_shoot"), new SoundEvent(new ResourceLocation("zombie_extreme", "self_made_shoot")));
        sounds.put(new ResourceLocation("zombie_extreme", "shoot_deagle"), new SoundEvent(new ResourceLocation("zombie_extreme", "shoot_deagle")));
        sounds.put(new ResourceLocation("zombie_extreme", "shoot_makarov"), new SoundEvent(new ResourceLocation("zombie_extreme", "shoot_makarov")));
        sounds.put(new ResourceLocation("zombie_extreme", "shoot_uzi"), new SoundEvent(new ResourceLocation("zombie_extreme", "shoot_uzi")));
        sounds.put(new ResourceLocation("zombie_extreme", "clicker_zombie"), new SoundEvent(new ResourceLocation("zombie_extreme", "clicker_zombie")));
        sounds.put(new ResourceLocation("zombie_extreme", "heavy_soldier_mask"), new SoundEvent(new ResourceLocation("zombie_extreme", "heavy_soldier_mask")));
        sounds.put(new ResourceLocation("zombie_extreme", "destroyer_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "destroyer_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "destroyer_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "destroyer_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "destroyer_step"), new SoundEvent(new ResourceLocation("zombie_extreme", "destroyer_step")));
        sounds.put(new ResourceLocation("zombie_extreme", "rat_king_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "rat_king_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_brute_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_brute_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_explosive_death"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_explosive_death")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_explosive_boom"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_explosive_boom")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_brute_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_brute_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_brute_death"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_brute_death")));
        sounds.put(new ResourceLocation("zombie_extreme", "zombie_explosive_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "zombie_explosive_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "fat_zombie_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "fat_zombie_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "fat_zombie_boom"), new SoundEvent(new ResourceLocation("zombie_extreme", "fat_zombie_boom")));
        sounds.put(new ResourceLocation("zombie_extreme", "fat_zombie_hurt_2"), new SoundEvent(new ResourceLocation("zombie_extreme", "fat_zombie_hurt_2")));
        sounds.put(new ResourceLocation("zombie_extreme", "reload_pistol"), new SoundEvent(new ResourceLocation("zombie_extreme", "reload_pistol")));
        sounds.put(new ResourceLocation("zombie_extreme", "empty_magazine"), new SoundEvent(new ResourceLocation("zombie_extreme", "empty_magazine")));
        sounds.put(new ResourceLocation("zombie_extreme", "shoot_block"), new SoundEvent(new ResourceLocation("zombie_extreme", "shoot_block")));
        sounds.put(new ResourceLocation("zombie_extreme", "night_hunter_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "night_hunter_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "night_hunter_step"), new SoundEvent(new ResourceLocation("zombie_extreme", "night_hunter_step")));
        sounds.put(new ResourceLocation("zombie_extreme", "night_hunter_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "night_hunter_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "infected_hazmat_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "infected_hazmat_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "wind_suond_radiation_dead_sea"), new SoundEvent(new ResourceLocation("zombie_extreme", "wind_suond_radiation_dead_sea")));
        sounds.put(new ResourceLocation("zombie_extreme", "step_on_trap"), new SoundEvent(new ResourceLocation("zombie_extreme", "step_on_trap")));
        sounds.put(new ResourceLocation("zombie_extreme", "idle_mother"), new SoundEvent(new ResourceLocation("zombie_extreme", "idle_mother")));
        sounds.put(new ResourceLocation("zombie_extreme", "hurt_mother"), new SoundEvent(new ResourceLocation("zombie_extreme", "hurt_mother")));
        sounds.put(new ResourceLocation("zombie_extreme", "murkuforce_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "murkuforce_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "infected_dog_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "infected_dog_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "infected_dog_step"), new SoundEvent(new ResourceLocation("zombie_extreme", "infected_dog_step")));
        sounds.put(new ResourceLocation("zombie_extreme", "infected_dog_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "infected_dog_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "revenant_sound_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "revenant_sound_idle")));
        sounds.put(new ResourceLocation("zombie_extreme", "revenant_sound_step"), new SoundEvent(new ResourceLocation("zombie_extreme", "revenant_sound_step")));
        sounds.put(new ResourceLocation("zombie_extreme", "revenant_idle_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "revenant_idle_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "poison_infected_hurt"), new SoundEvent(new ResourceLocation("zombie_extreme", "poison_infected_hurt")));
        sounds.put(new ResourceLocation("zombie_extreme", "poison_infected_idle"), new SoundEvent(new ResourceLocation("zombie_extreme", "poison_infected_idle")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("zombie_extreme").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        ZombieExtremeMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final ZombieExtremeModElements elements;
        protected final int sortid;

        public ModElement(ZombieExtremeModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

